/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes.fluid;

import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class DrainScenes {
    public static void emptying(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("item_drain", "Emptying Fluid Containers using Item Drains");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection drain = util.select().position(3, 1, 2);
        class_2338 drainPos = util.grid().at(3, 1, 2);
        Selection pipes = util.select().fromTo(3, 1, 3, 3, 1, 4).add(util.select().fromTo(3, 2, 4, 2, 2, 4));
        Selection tank = util.select().fromTo(1, 1, 4, 1, 3, 4);
        Selection largeCog = util.select().position(1, 0, 5);
        Selection kinetics = util.select().fromTo(2, 1, 3, 2, 1, 5);
        Selection belt = util.select().fromTo(2, 1, 2, 1, 1, 2);
        class_2338 beltPos = util.grid().at(1, 1, 2);
        ElementLink drainLink = scene.world().showIndependentSection(drain, class_2350.field_11033);
        scene.world().moveSection(drainLink, util.vector().of(-1.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(40).text("Item Drains can extract fluids from items").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(drainPos.method_10067(), class_2350.field_11036));
        scene.idle(50);
        class_1799 lavaBucket = new class_1799((class_1935)class_1802.field_8187);
        scene.overlay().showControls(util.vector().blockSurface(drainPos.method_10067(), class_2350.field_11036), Pointing.DOWN, 40).rightClick().withItem(lavaBucket);
        scene.idle(7);
        scene.world().modifyBlockEntity(drainPos, ItemDrainBlockEntity.class, be -> {
            be.getBehaviour(SmartFluidTankBehaviour.TYPE).allowInsertion();
            TransferUtil.insert(be.getFluidStorage(null), (Object)FluidVariant.of((class_3611)class_3612.field_15908), (long)81000L);
        });
        scene.idle(10);
        scene.overlay().showText(50).text("Right-click it to pour fluids from your held item into it").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(drainPos.method_10067(), class_2350.field_11039));
        scene.idle(60);
        scene.world().modifyBlockEntity(drainPos, ItemDrainBlockEntity.class, be -> TransferUtil.extractAnyFluid(be.getFluidStorage(null), (long)40500L));
        scene.world().moveSection(drainLink, util.vector().of(1.0, 0.0, 0.0), 7);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.idle(3);
        scene.world().showSection(kinetics, class_2350.field_11043);
        scene.idle(4);
        scene.world().showSection(belt, class_2350.field_11035);
        scene.idle(10);
        scene.overlay().showText(40).text("When items are inserted from the side...").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(util.grid().at(2, 1, 2)));
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(beltPos), Pointing.DOWN, 20).withItem(lavaBucket);
        scene.idle(7);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11043, lavaBucket);
        scene.idle(30);
        scene.overlay().showText(60).text("...they roll across, emptying out their contained fluid").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(drainPos));
        scene.idle(40);
        scene.world().showSection(tank, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(pipes, class_2350.field_11043);
        scene.idle(20);
        scene.overlay().showText(90).text("Pipe Networks can now pull the fluid from the drains' internal buffer").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(util.grid().at(3, 1, 3)));
        scene.idle(50);
        scene.markAsFinished();
        scene.idle(50);
        for (int i = 0; i < 5; ++i) {
            scene.world().createItemOnBelt(beltPos, class_2350.field_11043, lavaBucket);
            scene.idle(30);
        }
    }
}

