/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.data.filter.Filters;
import io.github.mortuusars.exposure.gui.screen.ItemListScreen;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraAttachmentsScreen
extends class_465<CameraAttachmentsMenu> {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/camera_attachments.png");
    protected final class_1657 player;
    protected Map<Integer, class_768> slotPlaceholders = Collections.emptyMap();
    protected final HoveredElement flash = new HoveredElement(List.of(new class_768(96, 11, 28, 27)), () -> ((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.FLASH_ATTACHMENT.slot()).method_7681());
    protected final HoveredElement filterOnLens = new HoveredElement(List.of(new class_768(114, 57, 13, 6), new class_768(110, 63, 17, 24)), () -> ((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.LENS_ATTACHMENT.slot()).method_7681());
    protected final HoveredElement lens = new HoveredElement(List.of(new class_768(93, 48, 33, 34)), () -> ((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.LENS_ATTACHMENT.slot()).method_7681());
    protected final HoveredElement filter = new HoveredElement(List.of(new class_768(110, 55, 13, 6), new class_768(106, 61, 17, 24)), () -> !((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.LENS_ATTACHMENT.slot()).method_7681());
    protected final HoveredElement lensBuiltIn = new HoveredElement(List.of(new class_768(93, 48, 29, 32)), () -> !((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.LENS_ATTACHMENT.slot()).method_7681());
    protected final HoveredElement viewfinder = new HoveredElement(List.of(new class_768(65, 25, 30, 12), new class_768(72, 31, 39, 11), new class_768(80, 42, 24, 5)), () -> true);
    @Nullable
    protected class_344 regularSkinButton;
    @Nullable
    protected class_344 goldSkinButton;

    public CameraAttachmentsScreen(CameraAttachmentsMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.player = playerInventory.field_7546;
    }

    public void method_49589() {
        OnePerPlayerSounds.play(this.player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), class_3419.field_15248, 0.9f, 0.9f);
    }

    protected void method_25426() {
        this.field_2779 = 185;
        this.field_25270 = this.field_2779 - 94;
        super.method_25426();
        this.slotPlaceholders = Map.of(CameraItem.FILM_ATTACHMENT.slot(), new class_768(238, 0, 18, 18), CameraItem.FLASH_ATTACHMENT.slot(), new class_768(238, 18, 18, 18), CameraItem.LENS_ATTACHMENT.slot(), new class_768(238, 36, 18, 18), CameraItem.FILTER_ATTACHMENT.slot(), new class_768(238, 54, 18, 18));
        if (Supporters.hasAccessToGoldenSkin(Objects.requireNonNull(class_310.method_1551().field_1724).method_5667())) {
            this.regularSkinButton = new class_344(this.field_2776 + 8, this.field_2800 + 18, 7, 7, 224, 0, 7, TEXTURE, b -> this.changeCameraSkin(false));
            this.goldSkinButton = new class_344(this.field_2776 + 8, this.field_2800 + 18, 7, 7, 231, 0, 7, TEXTURE, b -> this.changeCameraSkin(true));
            this.regularSkinButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.change_skin")));
            this.goldSkinButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.change_skin")));
            this.method_37063((class_364)this.regularSkinButton);
            this.method_37063((class_364)this.goldSkinButton);
        }
    }

    protected void changeCameraSkin(boolean isGold) {
        int buttonId = isGold ? 101 : 100;
        ((CameraAttachmentsMenu)this.method_17577()).method_7604((class_1657)Objects.requireNonNull(class_310.method_1551().field_1724), buttonId);
        Objects.requireNonNull(class_310.method_1551().field_1761).method_2900(((CameraAttachmentsMenu)this.method_17577()).field_7763, buttonId);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.regularSkinButton != null && this.goldSkinButton != null) {
            boolean isGold;
            this.regularSkinButton.field_22764 = isGold = ((CameraAttachmentsMenu)this.method_17577()).getCamera().getStack().method_7969() != null && ((CameraAttachmentsMenu)this.method_17577()).getCamera().getStack().method_7969().method_10577("GoldenCamera");
            this.goldSkinButton.field_22764 = !isGold;
        }
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (class_1735 slot : ((CameraAttachmentsMenu)this.method_17577()).field_7761) {
            if (slot.method_7674(this.player)) continue;
            guiGraphics.method_51427(slot.method_7677(), this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25291(TEXTURE, this.field_2776 + slot.field_7873 - 2, this.field_2800 + slot.field_7872 - 2, 350, 236.0f, 92.0f, 20, 20, 256, 256);
            RenderSystem.disableBlend();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        this.renderSlotPlaceholders(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAttachments(guiGraphics, mouseX, mouseY, partialTick);
        for (class_1735 slot : ((CameraAttachmentsMenu)this.method_17577()).field_7761) {
            if (slot.method_7674(this.player)) continue;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + slot.field_7873 - 2, this.field_2800 + slot.field_7872 - 2, 236, 72, 20, 20);
        }
        RenderSystem.disableBlend();
    }

    private void renderAttachments(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int filterY;
        boolean hasLens;
        if (((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.FLASH_ATTACHMENT.slot()).method_7681()) {
            int vOffset = this.isMouseOver(this.flash, mouseX, mouseY) ? 28 : 0;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 96, this.field_2800 + 11, 176, vOffset, 28, 28);
        }
        if (hasLens = ((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.LENS_ATTACHMENT.slot()).method_7681()) {
            int vOffset = this.isMouseOver(this.lens, mouseX, mouseY) && !this.isMouseOver(this.filterOnLens, mouseX, mouseY) ? 37 : 0;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 93, this.field_2800 + 47, 176, 56 + vOffset, 35, 37);
        } else if (this.isMouseOver(this.lensBuiltIn, mouseX, mouseY) && !this.isMouseOver(this.filter, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 93, this.field_2800 + 47, 176, 130, 31, 35);
        }
        class_1735 filterSlot = ((CameraAttachmentsMenu)this.method_17577()).method_7611(CameraItem.FILTER_ATTACHMENT.slot());
        int filterX = hasLens ? 102 : 98;
        int n = filterY = hasLens ? 54 : 52;
        if (filterSlot.method_7681()) {
            Filters.of(filterSlot.method_7677()).ifPresent(filter -> {
                int tintRGB = filter.getTintColor();
                float r = (float)(tintRGB >> 16 & 0xFF) / 255.0f;
                float g = (float)(tintRGB >> 8 & 0xFF) / 255.0f;
                float b = (float)(tintRGB & 0xFF) / 255.0f;
                if (this.isMouseOver(this.filterOnLens, mouseX, mouseY) || this.isMouseOver(this.filter, mouseX, mouseY)) {
                    r *= 1.35f;
                    g *= 1.35f;
                    b *= 1.35f;
                }
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                class_2960 filterTexture = filter.getAttachmentTexture();
                guiGraphics.method_25290(filterTexture, this.field_2776 + filterX, this.field_2800 + filterY, 0.0f, 0.0f, 32, 32, 32, 32);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
        } else if (this.isMouseOver(this.filterOnLens, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 110, this.field_2800 + 58, 176, 165, 15, 23);
        } else if (this.isMouseOver(this.filter, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 106, this.field_2800 + 56, 176, 165, 15, 23);
        }
        if (this.isMouseOver(this.viewfinder, mouseX, mouseY) && !this.isMouseOver(this.flash, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 65, this.field_2800 + 24, 42, 185, 49, 26);
        }
    }

    protected boolean isMouseOver(HoveredElement element, int mouseX, int mouseY) {
        if (!element.isEnabled.get().booleanValue()) {
            return false;
        }
        mouseX -= this.field_2776;
        mouseY -= this.field_2800;
        for (class_768 area : element.hoverArea) {
            if (mouseX < area.method_3321() || mouseX >= area.method_3321() + area.method_3319() || mouseY < area.method_3322() || mouseY >= area.method_3322() + area.method_3320()) continue;
            return true;
        }
        return false;
    }

    protected void renderSlotPlaceholders(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int slotIndex : this.slotPlaceholders.keySet()) {
            class_1735 slot = ((CameraAttachmentsMenu)this.method_17577()).method_7611(slotIndex);
            if (slot.method_7681()) continue;
            class_768 placeholder = this.slotPlaceholders.get(slotIndex);
            guiGraphics.method_25302(TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, placeholder.method_3321(), placeholder.method_3322(), placeholder.method_3319(), placeholder.method_3320());
        }
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.isMouseOver(this.flash, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.exposure.camera_attachments.flash.tooltip"), 230), x, y);
        } else if (this.isMouseOver(this.viewfinder, x, y)) {
            class_5250 key = class_2561.method_43470((String)ExposureClient.getCameraControlsKey().method_16007().getString()).method_27692(class_124.field_1080);
            class_5250 middleClick = (Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get() != false ? class_2561.method_43471((String)"gui.exposure.camera_attachments.viewfinder.tooltip.or_middle_click") : class_2561.method_43473();
            guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43469((String)"gui.exposure.camera_attachments.viewfinder.tooltip", (Object[])new Object[]{key, middleClick}), 230), x, y);
        } else if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.exposure.camera_attachments.filter.tooltip"), 230), x, y);
        } else if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.exposure.camera_attachments.lens.tooltip"), 230), x, y);
        } else {
            super.method_2380(guiGraphics, x, y);
        }
    }

    @NotNull
    protected List<class_2561> method_51454(class_1799 stack) {
        List tooltip = super.method_51454(stack);
        if (stack.method_31573(Exposure.Tags.Items.LENSES) && this.field_2787 != null && this.field_2787.method_7677().equals(stack)) {
            tooltip.add(class_2561.method_43469((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{FocalRange.ofStack(stack).method_15434()}).method_27692(class_124.field_1065));
        }
        return tooltip;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(Exposure.Tags.Items.FILTERS)) {
                itemStacks.add(new class_1799(holder));
            }
            ItemListScreen screen = new ItemListScreen((class_437)this, (class_2561)class_2561.method_43471((String)"gui.exposure.filters"), itemStacks){

                @Override
                protected List<class_2561> getTooltipFromContainerItem(class_1799 stack) {
                    List<class_2561> tooltip = super.getTooltipFromContainerItem(stack);
                    if (class_310.method_1551().field_1690.field_1827) {
                        Filters.of(stack).ifPresent(filter -> tooltip.add((class_2561)class_2561.method_43470((String)filter.getShader().toString()).method_27692(class_124.field_1080)));
                    }
                    return tooltip;
                }
            };
            class_310.method_1551().method_1507((class_437)screen);
            return true;
        }
        if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(Exposure.Tags.Items.LENSES)) {
                itemStacks.add(new class_1799(holder));
            }
            Object screen = new ItemListScreen((class_437)this, (class_2561)class_2561.method_43471((String)"gui.exposure.lenses"), itemStacks){

                @Override
                protected List<class_2561> getTooltipFromContainerItem(class_1799 stack) {
                    List<class_2561> tooltip = super.getTooltipFromContainerItem(stack);
                    Lenses.getFocalRangeOf(stack).ifPresent(fr -> tooltip.add((class_2561)class_2561.method_43469((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{fr.method_15434()}).method_27692(class_124.field_1065)));
                    return tooltip;
                }
            };
            class_310.method_1551().method_1507(screen);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public record HoveredElement(List<class_768> hoverArea, Supplier<Boolean> isEnabled) {
    }
}

