/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui.entry;

import com.google.gson.Gson;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.client.config.gui.ConfigScreen;
import io.github.jamalam360.jamlib.client.config.gui.entry.BooleanConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.EnumConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.FieldConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.ListConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.NumberConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.StringConfigEntry;
import io.github.jamalam360.jamlib.client.gui.ScrollingStringWidget;
import io.github.jamalam360.jamlib.client.gui.SpriteButton;
import io.github.jamalam360.jamlib.client.mixinsupport.MutableSpriteImageWidget;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_7919;
import net.minecraft.class_8208;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigEntry<T, V> {
    private static final Gson GSON = new Gson();
    protected final ConfigField<T, V> field;
    protected final ConfigManager<T> configManager;
    protected final V originalValue;
    private final String translationKey;
    @Nullable
    private final class_2561 tooltip;
    protected class_8208 validationIcon;
    @Nullable
    protected List<ConfigExtensions.ValidationError> errors;
    private boolean recreateWidgetsNextTick = false;

    public static <T, V> ConfigEntry<T, V> createFromField(String modId, String configName, Field field) {
        Class<?> c = field.getType();
        if (c == Boolean.TYPE) {
            return new BooleanConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c == Float.TYPE || c == Double.TYPE || c == Integer.TYPE || c == Long.TYPE) {
            return new NumberConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c == String.class) {
            return new StringConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c.isEnum()) {
            return new EnumConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (Collection.class.isAssignableFrom(c)) {
            return new ListConfigEntry(modId, configName, new FieldConfigField(field));
        }
        throw new IllegalArgumentException("Unsupported config field type " + String.valueOf(c));
    }

    public ConfigEntry(String modId, String configName, ConfigField<T, V> field) {
        this.field = field;
        this.configManager = ConfigManager.MANAGERS.get(new ConfigManager.Key(modId, configName));
        this.originalValue = this.cloneObject(this.getFieldValue());
        this.translationKey = ConfigScreen.createTranslationKey(modId, configName, field.getName());
        this.tooltip = class_1074.method_4663((String)(this.translationKey + ".tooltip")) ? class_2561.method_43471((String)(this.translationKey + ".tooltip")) : null;
    }

    public List<class_339> createWidgets(int width) {
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int n = 9 / 2 + 1;
        int n2 = width / 2 - 10;
        Objects.requireNonNull(class_310.method_1551().field_1772);
        ScrollingStringWidget title = new ScrollingStringWidget(12, n, n2, 9, (class_2561)class_2561.method_43471((String)this.translationKey), class_310.method_1551().field_1772);
        if (this.tooltip != null) {
            title.method_47400(class_7919.method_47407((class_2561)this.tooltip));
        }
        widgets.add((class_339)title);
        this.validationIcon = new class_8208(20, 20, JamLib.id("textures/gui/validation_warning.png"));
        this.validationIcon.method_46421(width - 212);
        this.validationIcon.method_46419(0);
        this.validationIcon.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.jamlib.requires_restart_tooltip")));
        this.validationIcon.field_22764 = false;
        widgets.add((class_339)this.validationIcon);
        widgets.addAll(this.createElementWidgets(width - 188, 150));
        SpriteButton resetButton = new SpriteButton(width - 30, 0, 20, 20, class_2561.method_43471((String)"config.jamlib.reset"), JamLib.id("textures/gui/reset.png"), 16, 16, button -> this.resetToDefault());
        resetButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.jamlib.reset_tooltip")));
        widgets.add((class_339)resetButton);
        return widgets;
    }

    public abstract List<class_339> createElementWidgets(int var1, int var2);

    public void onChange() {
        this.validate();
    }

    protected void validate() {
        V newValue = this.getFieldValue();
        if (this.configManager.get() instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)this.configManager.get();
            this.errors = ext.getValidationErrors(this.configManager, new ConfigExtensions.FieldValidationInfo(this.field.getName(), newValue, this.originalValue, this.field.getBackingField()));
            this.errors.sort((o1, o2) -> o2.type().ordinal() - o1.type().ordinal());
            this.updateValidationIcon();
        }
    }

    protected void updateValidationIcon() {
        if (this.validationIcon != null) {
            if (this.isValid()) {
                this.validationIcon.field_22764 = false;
            } else {
                this.validationIcon.field_22764 = true;
                ((MutableSpriteImageWidget)this.validationIcon).setSprite(this.errors.get(0).type().getTexture());
                this.validationIcon.method_47400(class_7919.method_47407((class_2561)this.errors.get(0).message()));
            }
        }
    }

    @Nullable
    public List<class_339> getNewWidgets(int width) {
        if (this.recreateWidgetsNextTick) {
            this.recreateWidgetsNextTick = false;
            return this.createWidgets(width);
        }
        return null;
    }

    public void recreateWidgetsNextTick() {
        this.recreateWidgetsNextTick = true;
    }

    public boolean hasChanged() {
        return this.getFieldValue().equals(this.originalValue);
    }

    public boolean isValid() {
        return this.errors == null || this.errors.stream().noneMatch(e -> e.type() == ConfigExtensions.ValidationError.Type.ERROR);
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)this.translationKey);
    }

    protected void resetToDefault() {
        this.setFieldValue(this.getDefaultValue());
    }

    protected V getFieldValue() {
        return this.field.getValue(this.configManager);
    }

    protected void setFieldValue(V v) {
        Object realValue = v;
        if (v instanceof Number) {
            Number n = (Number)v;
            Class<V> c = this.field.getElementType();
            if (c == Double.TYPE || c == Double.class) {
                realValue = n.doubleValue();
            } else if (c == Float.TYPE || c == Float.class) {
                realValue = Float.valueOf(n.floatValue());
            } else if (c == Integer.TYPE || c == Integer.class) {
                realValue = n.intValue();
            } else if (c == Long.TYPE || c == Long.class) {
                realValue = n.longValue();
            }
        }
        this.field.setValue(this.configManager, realValue);
        this.onChange();
    }

    private V getDefaultValue() {
        try {
            T defaultConfig = this.configManager.getConfigClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            return (V)this.field.getBackingField().get(defaultConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get default config for config " + String.valueOf(this.configManager.getConfigClass()), e);
        }
    }

    private V cloneObject(V object) {
        if (object == null) {
            return null;
        }
        return (V)GSON.fromJson(GSON.toJson(object), object.getClass());
    }
}

