/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.chassis;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllKeys;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.chassis.RadialChassisBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;

public class ChassisBlockEntity
extends SmartBlockEntity {
    ScrollValueBehaviour range;
    public int currentlySelectedRange;

    public ChassisBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        int max = (Integer)AllConfigs.server().kinetics.maxChassisRange.get();
        this.range = new ChassisScrollValueBehaviour((class_2561)CreateLang.translateDirect("contraptions.chassis.range", new Object[0]), this, new CenteredSideValueBoxTransform(), be -> ((ChassisBlockEntity)be).collectChassisGroup());
        this.range.requiresWrench();
        this.range.between(1, max);
        this.range.withClientCallback(i -> EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> ChassisRangeDisplay.display(this)));
        this.range.setValue(max / 2);
        this.range.withFormatter(s -> String.valueOf(this.currentlySelectedRange));
        behaviours.add(this.range);
        this.currentlySelectedRange = this.range.getValue();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.method_11010().method_26204() instanceof RadialChassisBlock) {
            this.range.setLabel((class_2561)CreateLang.translateDirect("contraptions.chassis.radius", new Object[0]));
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.currentlySelectedRange = this.getRange();
        }
    }

    public int getRange() {
        return this.range.getValue();
    }

    public List<class_2338> getIncludedBlockPositions(class_2350 forcedMovement, boolean visualize) {
        if (!(this.method_11010().method_26204() instanceof AbstractChassisBlock)) {
            return Collections.emptyList();
        }
        return this.isRadial() ? this.getIncludedBlockPositionsRadial(forcedMovement, visualize) : this.getIncludedBlockPositionsLinear(forcedMovement, visualize);
    }

    protected boolean isRadial() {
        return this.field_11863.method_8320(this.field_11867).method_26204() instanceof RadialChassisBlock;
    }

    public List<ChassisBlockEntity> collectChassisGroup() {
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        ArrayList<ChassisBlockEntity> collected = new ArrayList<ChassisBlockEntity>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        frontier.add(this.field_11867);
        while (!frontier.isEmpty()) {
            class_2338 current = (class_2338)frontier.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            class_2586 blockEntity = this.field_11863.method_8321(current);
            if (!(blockEntity instanceof ChassisBlockEntity)) continue;
            ChassisBlockEntity chassis = (ChassisBlockEntity)blockEntity;
            collected.add(chassis);
            visited.add(current);
            chassis.addAttachedChasses(frontier, visited);
        }
        return collected;
    }

    public boolean addAttachedChasses(Queue<class_2338> frontier, Set<class_2338> visited) {
        class_2680 state = this.method_11010();
        if (!(state.method_26204() instanceof AbstractChassisBlock)) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)AbstractChassisBlock.field_11459);
        if (this.isRadial()) {
            for (int offset : new int[]{-1, 1}) {
                class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
                class_2338 currentPos = this.field_11867.method_10079(direction, offset);
                if (!this.field_11863.method_8477(currentPos)) {
                    return false;
                }
                class_2680 neighbourState = this.field_11863.method_8320(currentPos);
                if (!AllBlocks.RADIAL_CHASSIS.has(neighbourState) || axis != neighbourState.method_11654((class_2769)class_2741.field_12496) || visited.contains(currentPos)) continue;
                frontier.add(currentPos);
            }
            return true;
        }
        for (class_2350 offset : Iterate.directions) {
            class_2338 current = this.field_11867.method_10093(offset);
            if (visited.contains(current)) continue;
            if (!this.field_11863.method_8477(current)) {
                return false;
            }
            class_2680 neighbourState = this.field_11863.method_8320(current);
            if (!LinearChassisBlock.isChassis(neighbourState) || !LinearChassisBlock.sameKind(state, neighbourState) || neighbourState.method_11654((class_2769)LinearChassisBlock.field_11459) != axis) continue;
            frontier.add(current);
        }
        return true;
    }

    private List<class_2338> getIncludedBlockPositionsLinear(class_2350 forcedMovement, boolean visualize) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2680 state = this.method_11010();
        AbstractChassisBlock block = (AbstractChassisBlock)state.method_26204();
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)AbstractChassisBlock.field_11459);
        class_2350 facing = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        int chassisRange = visualize ? this.currentlySelectedRange : this.getRange();
        block0: for (int offset : new int[]{1, -1}) {
            if (offset == -1) {
                facing = facing.method_10153();
            }
            boolean sticky = (Boolean)state.method_11654((class_2769)block.getGlueableSide(state, facing));
            for (int i = 1; i <= chassisRange; ++i) {
                class_2338 current = this.field_11867.method_10079(facing, i);
                class_2680 currentState = this.field_11863.method_8320(current);
                if (forcedMovement != facing && !sticky || !BlockMovementChecks.isMovementNecessary(currentState, this.field_11863, current) || BlockMovementChecks.isBrittle(currentState)) continue block0;
                positions.add(current);
                if (BlockMovementChecks.isNotSupportive(currentState, facing)) continue block0;
            }
        }
        return positions;
    }

    private List<class_2338> getIncludedBlockPositionsRadial(class_2350 forcedMovement, boolean visualize) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)AbstractChassisBlock.field_11459);
        AbstractChassisBlock block = (AbstractChassisBlock)state.method_26204();
        int chassisRange = visualize ? this.currentlySelectedRange : this.getRange();
        for (class_2350 facing : Iterate.directions) {
            if (facing.method_10166() == axis || !((Boolean)state.method_11654((class_2769)block.getGlueableSide(state, facing))).booleanValue()) continue;
            class_2338 startPos = this.field_11867.method_10093(facing);
            LinkedList<class_2338> localFrontier = new LinkedList<class_2338>();
            HashSet<class_2338> localVisited = new HashSet<class_2338>();
            localFrontier.add(startPos);
            while (!localFrontier.isEmpty()) {
                class_2338 searchPos = (class_2338)localFrontier.remove(0);
                class_2680 searchedState = this.field_11863.method_8320(searchPos);
                if (localVisited.contains(searchPos) || !searchPos.method_19771((class_2382)this.field_11867, (double)((float)chassisRange + 0.5f)) || !BlockMovementChecks.isMovementNecessary(searchedState, this.field_11863, searchPos) || BlockMovementChecks.isBrittle(searchedState)) continue;
                localVisited.add(searchPos);
                if (!searchPos.equals((Object)this.field_11867)) {
                    positions.add(searchPos);
                }
                for (class_2350 offset : Iterate.directions) {
                    if (offset.method_10166() == axis || searchPos.equals((Object)this.field_11867) && offset != facing || BlockMovementChecks.isNotSupportive(searchedState, offset)) continue;
                    localFrontier.add(searchPos.method_10093(offset));
                }
            }
        }
        return positions;
    }

    class ChassisScrollValueBehaviour
    extends BulkScrollValueBehaviour {
        public ChassisScrollValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot, Function<SmartBlockEntity, List<? extends SmartBlockEntity>> groupGetter) {
            super(label, be, slot, groupGetter);
        }

        @Override
        public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
            ImmutableList rows = ImmutableList.of((Object)CreateLang.translateDirect("contraptions.chassis.distance", new Object[0]));
            ValueSettingsFormatter formatter = new ValueSettingsFormatter(vs -> new ValueSettingsBehaviour.ValueSettings(vs.row(), vs.value() + 1).format());
            return new ValueSettingsBoard(this.label, this.max - 1, 1, (List<class_2561>)rows, formatter);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void newSettingHovered(ValueSettingsBehaviour.ValueSettings valueSetting) {
            if (!((ChassisBlockEntity)ChassisBlockEntity.this).field_11863.field_9236) {
                return;
            }
            if (!AllKeys.ctrlDown()) {
                ChassisBlockEntity.this.currentlySelectedRange = valueSetting.value() + 1;
            } else {
                for (SmartBlockEntity smartBlockEntity : this.getBulk()) {
                    if (!(smartBlockEntity instanceof ChassisBlockEntity)) continue;
                    ChassisBlockEntity cbe = (ChassisBlockEntity)smartBlockEntity;
                    cbe.currentlySelectedRange = valueSetting.value() + 1;
                }
            }
            ChassisRangeDisplay.display(ChassisBlockEntity.this);
        }

        @Override
        public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings vs, boolean ctrlHeld) {
            super.setValueSettings(player, new ValueSettingsBehaviour.ValueSettings(vs.row(), vs.value() + 1), ctrlHeld);
        }

        @Override
        public ValueSettingsBehaviour.ValueSettings getValueSettings() {
            ValueSettingsBehaviour.ValueSettings vs = super.getValueSettings();
            return new ValueSettingsBehaviour.ValueSettings(vs.row(), vs.value() - 1);
        }

        @Override
        public String getClipboardKey() {
            return "Chassis";
        }
    }
}

