/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.LitBlazeBurnerBlock;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1506;
import net.minecraft.class_1560;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3862;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AllFanProcessingTypes {
    public static final BlastingType BLASTING = AllFanProcessingTypes.register("blasting", new BlastingType());
    public static final HauntingType HAUNTING = AllFanProcessingTypes.register("haunting", new HauntingType());
    public static final SmokingType SMOKING = AllFanProcessingTypes.register("smoking", new SmokingType());
    public static final SplashingType SPLASHING = AllFanProcessingTypes.register("splashing", new SplashingType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String name, T type) {
        return (T)((FanProcessingType)class_2378.method_10230(CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (class_2960)Create.asResource(name), type));
    }

    public static void init() {
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    @Nullable
    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = AllFanProcessingTypes.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse(str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"BLASTING", (Object)BLASTING);
        map.put((Object)"HAUNTING", (Object)HAUNTING);
        map.put((Object)"SMOKING", (Object)SMOKING);
        map.put((Object)"SPLASHING", (Object)SPLASHING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class BlastingType
    implements FanProcessingType {
        private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper(new ItemStackHandler(1));

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_BLASTING.matches(blockState)) {
                return !blockState.method_28498(BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)((Object)blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL))).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> smeltingRecipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> blastingRecipe = level.method_8433().method_8132(class_3956.field_17547, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.method_7909().method_24358();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> smokingRecipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> smeltingRecipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (!smeltingRecipe.isPresent()) {
                RECIPE_WRAPPER.method_5447(0, stack);
                smeltingRecipe = level.method_8433().method_8132(class_3956.field_17547, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            }
            if (smeltingRecipe.isPresent()) {
                class_5455 registryAccess = level.method_30349();
                if (!smokingRecipe.isPresent() || !class_1799.method_7984((class_1799)((class_3862)smokingRecipe.get()).method_8110(registryAccess), (class_1799)((class_1874)smeltingRecipe.get()).method_8110(registryAccess))) {
                    return RecipeApplier.applyRecipeOn(level, stack, smeltingRecipe.get(), false);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0xFF4400, (int)0xFF8855, (float)random.method_43057()));
            particleAccess.setAlpha(0.5f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11240, 0.25f);
            }
            if (random.method_43057() < 0.0625f) {
                particleAccess.spawnExtraParticle((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10164.method_9564()), 0.25f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(10);
                entity.method_5643(CreateDamageSources.fanLava(level), 4.0f);
            }
        }
    }

    public static class HauntingType
    implements FanProcessingType {
        private static final HauntingRecipe.HauntingWrapper HAUNTING_WRAPPER = new HauntingRecipe.HauntingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING.matches(blockState)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                return !blockState.method_28498(LitBlazeBurnerBlock.FLAME_TYPE) || blockState.method_11654(LitBlazeBurnerBlock.FLAME_TYPE) == LitBlazeBurnerBlock.FlameType.SOUL;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 300;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            HAUNTING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            HAUNTING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.HAUNTING.find(HAUNTING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn(level, stack, (class_1860)recipe.get(), true);
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            pos = pos.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)level.field_9229, (float)1.0f).method_18805(1.0, (double)0.05f, 1.0).method_1029().method_1021((double)0.15f));
            level.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + (double)0.45f, pos.field_1350, 0.0, 0.0, 0.0);
            if (level.field_9229.method_43048(2) == 0) {
                level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1205608, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.0078125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_22246, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                if (entity instanceof class_1498) {
                    class_243 p = entity.method_30950(0.0f);
                    class_243 v = p.method_1031(0.0, 0.5, 0.0).method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)level.field_9229, (float)1.0f).method_18805(1.0, (double)0.2f, 1.0).method_1029().method_1021(1.0));
                    level.method_8406((class_2394)class_2398.field_22246, v.field_1352, v.field_1351, v.field_1350, 0.0, (double)0.1f, 0.0);
                    if (level.field_9229.method_43048(3) == 0) {
                        level.method_8406((class_2394)class_2398.field_11237, p.field_1352, p.field_1351 + 0.5, p.field_1350, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), (double)0.1f, (double)((level.field_9229.method_43057() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
                livingEntity.method_6092(new class_1293(class_1294.field_5909, 20, 1, false, false));
            }
            if (entity instanceof class_1498) {
                class_1498 horse = (class_1498)entity;
                int progress = horse.getCustomData().method_10550("CreateHaunting");
                if (progress < 100) {
                    if (progress % 10 == 0) {
                        level.method_8396(null, entity.method_24515(), class_3417.field_23060, class_3419.field_15254, 1.0f, 1.5f * (float)progress / 100.0f);
                    }
                    horse.getCustomData().method_10569("CreateHaunting", progress + 1);
                    return;
                }
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 1.25f, 0.65f);
                class_1506 skeletonHorse = (class_1506)class_1299.field_6075.method_5883(level);
                class_2487 serializeNBT = horse.method_5647(new class_2487());
                serializeNBT.method_10551("UUID");
                if (!horse.method_6786().method_7960()) {
                    horse.method_5775(horse.method_6786());
                }
                NBTSerializer.deserializeNBT((Object)skeletonHorse, (class_2520)serializeNBT);
                skeletonHorse.method_33574(horse.method_30950(0.0f));
                level.method_8649((class_1297)skeletonHorse);
                horse.method_31472();
            }
        }
    }

    public static class SmokingType
    implements FanProcessingType {
        private static final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper(new ItemStackHandler(1));

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            if (AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING.matches(blockState)) {
                if (blockState.method_26164(class_3481.field_23799) && blockState.method_28498((class_2769)class_3922.field_17352) && !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    return false;
                }
                if (blockState.method_28498(LitBlazeBurnerBlock.FLAME_TYPE) && blockState.method_11654(LitBlazeBurnerBlock.FLAME_TYPE) != LitBlazeBurnerBlock.FlameType.REGULAR) {
                    return false;
                }
                return !blockState.method_28498(BlazeBurnerBlock.HEAT_LEVEL) || blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.SMOULDERING;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 200;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> recipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            RECIPE_WRAPPER.method_5447(0, stack);
            Optional<class_1860<?>> smokingRecipe = level.method_8433().method_8132(class_3956.field_17548, (class_1263)RECIPE_WRAPPER, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smokingRecipe.isPresent()) {
                return RecipeApplier.applyRecipeOn(level, stack, smokingRecipe.get(), false);
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            level.method_8406((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.25, pos.field_1350, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)0x555555, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11251, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11237, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (!entity.method_5753()) {
                entity.method_5639(2);
                entity.method_5643(CreateDamageSources.fanFire(level), 2.0f);
            }
        }
    }

    public static class SplashingType
    implements FanProcessingType {
        private static final SplashingRecipe.SplashingWrapper SPLASHING_WRAPPER = new SplashingRecipe.SplashingWrapper();

        @Override
        public boolean isValidAt(class_1937 level, class_2338 pos) {
            class_3610 fluidState = level.method_8316(pos);
            if (AllTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(fluidState)) {
                return true;
            }
            class_2680 blockState = level.method_8320(pos);
            return AllTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SPLASHING.matches(blockState);
        }

        @Override
        public int getPriority() {
            return 400;
        }

        @Override
        public boolean canProcess(class_1799 stack, class_1937 level) {
            SPLASHING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Override
        @Nullable
        public List<class_1799> process(class_1799 stack, class_1937 level) {
            SPLASHING_WRAPPER.method_5447(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn(level, stack, (class_1860)recipe.get(), true);
            }
            return null;
        }

        @Override
        public void spawnProcessingParticles(class_1937 level, class_243 pos) {
            if (level.field_9229.method_43048(8) != 0) {
                return;
            }
            Vector3f color = new Color(22015).asVectorF();
            level.method_8406((class_2394)new class_2390(color, 1.0f), pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.method_8406((class_2394)class_2398.field_11228, pos.field_1352 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), pos.field_1351 + 0.5, pos.field_1350 + (double)((level.field_9229.method_43057() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, class_5819 random) {
            particleAccess.setColor(Color.mixColors((int)0x4499FF, (int)0x2277FF, (float)random.method_43057()));
            particleAccess.setAlpha(1.0f);
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11247, 0.125f);
            }
            if (random.method_43057() < 0.03125f) {
                particleAccess.spawnExtraParticle((class_2394)class_2398.field_11241, 0.125f);
            }
        }

        @Override
        public void affectEntity(class_1297 entity, class_1937 level) {
            if (level.field_9236) {
                return;
            }
            if (entity instanceof class_1560 || entity.method_5864() == class_1299.field_6047 || entity.method_5864() == class_1299.field_6099) {
                entity.method_5643(entity.method_48923().method_48824(), 2.0f);
            }
            if (entity.method_5809()) {
                entity.method_5646();
                level.method_8396(null, entity.method_24515(), class_3417.field_15222, class_3419.field_15254, 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
            }
        }
    }
}

