/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.graph;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TrackGraphHelper {
    @Nullable
    public static TrackGraphLocation getGraphLocationAt(class_1937 level, class_2338 pos, class_2350.class_2352 targetDirection, class_243 targetAxis) {
        TrackNode node;
        class_2680 trackBlockState = level.method_8320(pos);
        class_2248 class_22482 = trackBlockState.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return null;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        class_243 axis = targetAxis.method_1021((double)targetDirection.method_10181());
        double length = axis.method_1033();
        TrackGraph graph = null;
        TrackNodeLocation location = new TrackNodeLocation(class_243.method_24955((class_2382)pos).method_1031(0.0, track.getElevationAtCenter((class_1922)level, pos, trackBlockState), 0.0)).in(level);
        graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, location);
        if (graph != null && (node = graph.locateNode(location)) != null) {
            Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node);
            for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFrom.entrySet()) {
                TrackNode backNode = entry.getKey();
                class_243 direction = entry.getValue().getDirection(true);
                if (direction.method_1021(length).method_1025(axis.method_1021(-1.0)) > 2.44140625E-4) continue;
                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.edge = Couple.create((Object)((Object)node.getLocation()), (Object)((Object)backNode.getLocation()));
                graphLocation.position = 0.0;
                graphLocation.graph = graph;
                return graphLocation;
            }
        }
        Collection<TrackNodeLocation.DiscoveredLocation> ends = track.getConnected((class_1922)level, pos, trackBlockState, true, null);
        class_243 start = class_243.method_24955((class_2382)pos).method_1031(0.0, track.getElevationAtCenter((class_1922)level, pos, trackBlockState), 0.0);
        TrackNode frontNode = null;
        TrackNode backNode = null;
        double position = 0.0;
        boolean singleTrackPiece = true;
        block1: for (TrackNodeLocation.DiscoveredLocation current : ends) {
            boolean backwards;
            class_243 offset = current.getLocation().method_1020(start).method_1029().method_1021(length);
            class_243 compareOffset = offset.method_18805(1.0, 0.0, 1.0).method_1029();
            boolean forward = compareOffset.method_1025(axis.method_18805(-1.0, 0.0, -1.0).method_1029()) < 2.44140625E-4;
            boolean bl = backwards = compareOffset.method_1025(axis.method_18805(1.0, 0.0, 1.0).method_1029()) < 2.44140625E-4;
            if (!forward && !backwards) continue;
            TrackNodeLocation.DiscoveredLocation previous = null;
            double distance = 0.0;
            block2: for (int i = 0; i < 100 && distance < 32.0; ++i) {
                TrackNodeLocation.DiscoveredLocation loc = current;
                if (graph == null) {
                    graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, loc);
                }
                if (graph == null || graph.locateNode(loc) == null) {
                    singleTrackPiece = false;
                    Collection<TrackNodeLocation.DiscoveredLocation> list = ITrackBlock.walkConnectedTracks((class_1922)level, loc, true);
                    for (TrackNodeLocation.DiscoveredLocation discoveredLocation : list) {
                        if (discoveredLocation == previous) continue;
                        class_243 diff = discoveredLocation.getLocation().method_1020(loc.getLocation());
                        if ((forward ? axis.method_1021(-1.0) : axis).method_1025(diff.method_1029().method_1021(length)) > 2.44140625E-4) continue;
                        previous = current;
                        current = discoveredLocation;
                        distance += diff.method_1033();
                        continue block2;
                    }
                    continue;
                }
                TrackNode node2 = graph.locateNode(loc);
                if (forward) {
                    frontNode = node2;
                }
                if (!backwards) continue block1;
                backNode = node2;
                position = distance + axis.method_1033() / 2.0;
                continue block1;
            }
        }
        if (frontNode == null || backNode == null) {
            return null;
        }
        if (singleTrackPiece) {
            position = frontNode.getLocation().getLocation().method_1022(backNode.getLocation().getLocation()) / 2.0;
        }
        TrackGraphLocation graphLocation = new TrackGraphLocation();
        graphLocation.edge = Couple.create((Object)((Object)backNode.getLocation()), (Object)((Object)frontNode.getLocation()));
        graphLocation.position = position;
        graphLocation.graph = graph;
        return graphLocation;
    }

    @Nullable
    public static TrackGraphLocation getBezierGraphLocationAt(class_1937 level, class_2338 pos, class_2350.class_2352 targetDirection, BezierTrackPointLocation targetBezier) {
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return null;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof TrackBlockEntity)) {
            return null;
        }
        TrackBlockEntity trackBE = (TrackBlockEntity)class_25862;
        BezierConnection bc = trackBE.getConnections().get(targetBezier.curveTarget());
        if (bc == null || !bc.isPrimary()) {
            return null;
        }
        TrackNodeLocation targetLoc = new TrackNodeLocation((class_243)bc.starts.getSecond()).in(level);
        if (bc.smoothing != null) {
            targetLoc.yOffsetPixels = (Integer)bc.smoothing.getSecond();
        }
        for (TrackNodeLocation.DiscoveredLocation location : track.getConnected((class_1922)level, pos, state, true, null)) {
            TrackNode node;
            TrackEdge edge;
            TrackNode targetNode;
            TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, location);
            if (graph == null || (targetNode = graph.locateNode(targetLoc)) == null || (edge = graph.getConnectionsFrom(node = graph.locateNode(location)).get(targetNode)) == null) continue;
            TrackGraphLocation graphLocation = new TrackGraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = Couple.create((Object)((Object)location), (Object)((Object)targetLoc));
            graphLocation.position = (float)(targetBezier.segment() + 1) / 2.0f;
            if (targetDirection == class_2350.class_2352.field_11056) {
                graphLocation.edge = graphLocation.edge.swap();
                graphLocation.position = edge.getLength() - graphLocation.position;
            }
            return graphLocation;
        }
        return null;
    }
}

