/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.foundation.data.recipe.Mods;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.lang.Lang;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public enum CommonMetal {
    IRON(Mods.VANILLA),
    GOLD(Mods.VANILLA),
    COPPER(Mods.VANILLA),
    ZINC(Mods.CREATE),
    BRASS(false, Mods.CREATE),
    ALUMINUM(Mods.IE, Mods.IC2),
    LEAD(Mods.MEK, Mods.TH, Mods.IE, Mods.OREGANIZED, Mods.TR, Mods.MI),
    NICKEL(Mods.TH, Mods.IE, Mods.MI, Mods.ALG),
    OSMIUM(Mods.MEK, Mods.MTM),
    PLATINUM(Mods.MTM, Mods.MI),
    QUICKSILVER(new Mods[0]),
    SILVER(Mods.TH, Mods.IE, Mods.IC2, Mods.OREGANIZED, Mods.GS, Mods.IF, Mods.TR, Mods.MI, Mods.MTM, Mods.BWT),
    TIN(Mods.TH, Mods.MEK, Mods.IC2, Mods.TR, Mods.MI, Mods.ALG, Mods.MTM),
    URANIUM(Mods.MEK, Mods.IE, Mods.IC2, Mods.MI),
    CONSTANTAN(false, Mods.IE),
    ELECTRUM(false, Mods.IE, Mods.MI),
    STEEL(false, Mods.IE, Mods.MI);

    private static final Map<Mods, Set<CommonMetal>> metalsOfMods;
    public final String name = Lang.asId((String)this.name());
    public final Set<Mods> mods;
    public final boolean isNatural;
    public final ItemLikeTag ores;
    public final class_6862<class_1792> rawOres;
    public final ItemLikeTag rawStorageBlocks;
    public final class_6862<class_1792> ingots;
    public final ItemLikeTag storageBlocks;
    public final class_6862<class_1792> nuggets;
    public final class_6862<class_1792> plates;

    private CommonMetal(Mods ... mods) {
        this(true, mods);
    }

    private CommonMetal(boolean natural, Mods ... mods) {
        this.mods = mods.length == 0 ? Set.of() : Collections.unmodifiableSet(EnumSet.copyOf(Set.of(mods)));
        this.isNatural = natural;
        this.ores = new ItemLikeTag(this.name + "_ores");
        this.rawOres = CommonMetal.itemTag("raw_" + this.name + "_ores");
        this.rawStorageBlocks = new ItemLikeTag("raw_" + this.name + "_blocks");
        this.ingots = CommonMetal.itemTag(this.name + "_ingots");
        this.storageBlocks = new ItemLikeTag(this.name + "_blocks");
        this.nuggets = CommonMetal.itemTag(this.name + "_nuggets");
        this.plates = CommonMetal.itemTag(this.name + "_plates");
    }

    public String getName(Mods mod) {
        if (this == ALUMINUM && mod == Mods.IC2) {
            return "aluminium";
        }
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Set<CommonMetal> of(Mods mod) {
        return metalsOfMods.get(mod);
    }

    private static class_6862<class_1792> itemTag(String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", path));
    }

    private static class_6862<class_2248> blockTag(String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("c", path));
    }

    static {
        metalsOfMods = (Map)class_156.method_656(() -> {
            EnumMap<Mods, EnumSet<CommonMetal>> map = new EnumMap<Mods, EnumSet<CommonMetal>>(Mods.class);
            for (Mods mod : Mods.values()) {
                EnumSet<CommonMetal> set = EnumSet.noneOf(CommonMetal.class);
                for (CommonMetal metal : CommonMetal.values()) {
                    if (!metal.mods.contains(mod)) continue;
                    set.add(metal);
                }
                map.put(mod, set);
            }
            return map;
        });
    }

    public record ItemLikeTag(class_6862<class_1792> items, class_6862<class_2248> blocks) {
        private ItemLikeTag(String path) {
            this(CommonMetal.itemTag(path), CommonMetal.blockTag(path));
        }
    }
}

