/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.pack;

import com.google.gson.JsonElement;
import com.simibubi.create.Create;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicPack
implements class_3262 {
    private final Map<String, class_7367<InputStream>> files = new HashMap<String, class_7367<InputStream>>();
    private final String packId;
    private final class_3264 packType;
    private final class_3272 metadata;

    public DynamicPack(String packId, class_3264 packType) {
        this.packId = packId;
        this.packType = packType;
        this.metadata = new class_3272((class_2561)class_2561.method_43473(), class_155.method_16673().method_48017(packType));
    }

    private static String getPath(class_3264 packType, class_2960 resourceLocation) {
        return packType.method_14413() + "/" + resourceLocation.method_12836() + "/" + resourceLocation.method_12832();
    }

    public DynamicPack put(class_2960 location, class_7367<InputStream> stream) {
        this.files.put(DynamicPack.getPath(this.packType, location), stream);
        return this;
    }

    public DynamicPack put(class_2960 location, byte[] bytes) {
        return this.put(location, (class_7367<InputStream>)((class_7367)() -> new ByteArrayInputStream(bytes)));
    }

    public DynamicPack put(class_2960 location, String string) {
        return this.put(location, string.getBytes(StandardCharsets.UTF_8));
    }

    public DynamicPack put(class_2960 location, JsonElement json) {
        return this.put(location.method_48331(".json"), Create.GSON.toJson(json));
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        return this.files.getOrDefault(String.join((CharSequence)"/", elements), null);
    }

    @Nullable
    public class_7367<InputStream> method_14405(@NotNull class_3264 packType, @NotNull class_2960 resourceLocation) {
        return this.files.getOrDefault(DynamicPack.getPath(packType, resourceLocation), null);
    }

    public void method_14408(@NotNull class_3264 packType, @NotNull String namespace, @NotNull String path, @NotNull class_3262.class_7664 resourceOutput) {
        class_2960 resourceLocation = new class_2960(namespace, path);
        String directoryAndNamespace = packType.method_14413() + "/" + namespace + "/";
        String prefix = directoryAndNamespace + path + "/";
        this.files.forEach((filePath, streamSupplier) -> {
            if (filePath.startsWith(prefix)) {
                resourceOutput.accept((Object)resourceLocation.method_45136(filePath.substring(directoryAndNamespace.length())), streamSupplier);
            }
        });
    }

    @NotNull
    public Set<String> method_14406(class_3264 packType) {
        HashSet<String> namespaces = new HashSet<String>();
        String dir = packType.method_14413() + "/";
        for (String path : this.files.keySet()) {
            String relative;
            if (!path.startsWith(dir) || !(relative = path.substring(dir.length())).contains("/")) continue;
            namespaces.add(relative.substring(0, relative.indexOf("/")));
        }
        return namespaces;
    }

    @Nullable
    public <T> T method_14407(@NotNull class_3270<T> deserializer) throws IOException {
        return (T)(deserializer == class_3272.field_14202 ? this.metadata : null);
    }

    @NotNull
    public String method_14409() {
        return this.packId;
    }

    public void close() {
    }
}

