/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.Create;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class RecipeFinder {
    private static final Cache<Object, List<class_1860<?>>> CACHED_SEARCHES = CacheBuilder.newBuilder().build();
    public static final IdentifiableResourceReloadListener LISTENER = new SimpleSynchronousResourceReloadListener(){

        public class_2960 getFabricId() {
            return Create.asResource("recipe_finder");
        }

        public void method_14491(class_3300 resourceManager) {
            CACHED_SEARCHES.invalidateAll();
        }
    };

    public static List<class_1860<?>> get(@Nullable Object cacheKey, class_1937 level, Predicate<class_1860<?>> conditions) {
        if (cacheKey == null) {
            return RecipeFinder.startSearch(level, conditions);
        }
        try {
            return (List)CACHED_SEARCHES.get(cacheKey, () -> RecipeFinder.startSearch(level, conditions));
        }
        catch (ExecutionException e) {
            Create.LOGGER.error("Encountered a exception while searching for recipes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<class_1860<?>> startSearch(class_1937 level, Predicate<? super class_1860<?>> conditions) {
        ArrayList recipes = new ArrayList();
        for (class_1860 r : level.method_8433().method_8126()) {
            if (!conditions.test(r)) continue;
            recipes.add(r);
        }
        return recipes;
    }
}

