/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<class_2960, IntList> DIMENSION_COLOR_MAP = new HashMap();
    private static final IntList SEPIA_COLORS = new IntArrayList();

    public static void refreshTextures() {
        TEXTURE_CACHE.clear();
    }

    public static class_1921 getRenderType(class_1937 world, boolean sepia) {
        return GlobeManager.getTextureInstance((class_1937)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(class_1937 world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(class_1937 level, boolean sepia) {
        Object id = level.method_27983().method_29177().method_12832();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static int getColorForPalette(byte b, class_2960 dimension, boolean sepia) {
        if (sepia) {
            return SEPIA_COLORS.getInt((int)b);
        }
        IntList l = DIMENSION_COLOR_MAP.getOrDefault(dimension, DIMENSION_COLOR_MAP.get(new class_2960("overworld")));
        if (l != null) {
            return l.getInt((int)b);
        }
        return 1;
    }

    public static void refreshColorsAndTextures(class_3300 manager) {
        Type.recomputeCache();
        DIMENSION_COLOR_MAP.clear();
        int targetColors = 13;
        for (class_2960 res : manager.method_14488("textures/entity/globes/palettes", r -> r.method_12832().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((class_3300)manager, (class_2960)res, (int)targetColors);
            String name = res.method_12832();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll((Collection)l);
                continue;
            }
            DIMENSION_COLOR_MAP.put(new class_2960(name.replace(".", ":")), (IntList)new IntArrayList((Collection)l));
        }
        if (DIMENSION_COLOR_MAP.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.refreshTextures();
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final class_2960 textureLocation;
        private final class_1043 texture;
        private final class_1921 renderType;
        private final class_2960 dimensionId;
        private final boolean sepia;

        private TextureInstance(class_1937 world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.method_27983().method_29177();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture = new class_1043(32, 16, false);
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
            this.updateTexture(world);
            this.textureLocation = class_310.method_1551().method_1531().method_4617("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
            this.renderType = RenderUtil.getEntitySolidMipmapRenderType((class_2960)this.textureLocation);
        }

        private void updateTexture(class_1937 world) {
            GlobeData data = GlobeData.get(world);
            if (data == null) {
                return;
            }
            byte[][] pixels = data.globePixels;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.method_4525().method_4305(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.method_4525().method_4305(y, x, GlobeManager.getColorForPalette(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture.method_4524();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
        }

        @Override
        public void close() {
            this.texture.close();
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
        }
    }

    public static enum Type {
        FLAT(new String[]{"flat", "flat earth"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.earth"), ModTextures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE);

        private final String[] keyWords;
        public final class_2561 transKeyWord;
        public final class_2960 texture;
        private static final Map<String, Pair<Model, class_2960>> nameCache;
        private static final Map<String, Integer> idMap;
        public static final List<class_2960> textures;

        private Type(String[] key, class_2561 tr, class_2960 res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public static void recomputeCache() {
            nameCache.clear();
            for (Type type : Type.values()) {
                Model model = type == FLAT ? Model.FLAT : Model.GLOBE;
                Pair pair = Pair.of((Object)((Object)model), (Object)type.texture);
                if (type.transKeyWord != null && !type.transKeyWord.getString().equals("")) {
                    nameCache.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), (Pair<Model, class_2960>)pair);
                }
                for (String s : type.keyWords) {
                    if (s.equals("")) continue;
                    nameCache.put(s, (Pair<Model, class_2960>)pair);
                }
            }
            for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
                class_2960 path = (class_2960)entry.getValue();
                Model model = Model.GLOBE;
                if (path.method_12832().contains("globe_wais")) {
                    model = Model.SNOW;
                }
                nameCache.put((String)entry.getKey(), (Pair<Model, class_2960>)Pair.of((Object)((Object)model), (Object)path));
            }
            textures.clear();
            nameCache.values().forEach(o -> {
                if (!textures.contains(o.getSecond())) {
                    textures.add((class_2960)o.getSecond());
                }
            });
            Collections.sort(textures);
            idMap.clear();
            nameCache.forEach((key, value) -> idMap.put((String)key, textures.indexOf(value.getSecond())));
        }

        @Nullable
        public static Pair<Model, class_2960> getModelAndTexture(String text) {
            return nameCache.get(text.toLowerCase(Locale.ROOT));
        }

        @Nullable
        public static Integer getTextureID(String text) {
            return idMap.get(text.toLowerCase(Locale.ROOT));
        }

        static {
            nameCache = new HashMap<String, Pair<Model, class_2960>>();
            idMap = new HashMap<String, Integer>();
            textures = new ArrayList<class_2960>();
        }
    }

    public static enum Model {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED;

    }
}

