/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5699;

public final class BookType {
    public static final Codec<BookType> CODEC = class_5699.method_39508(BookType::name, PlaceableBookManager::getByName);
    private final String name;
    private final float hue;
    private final float hueShift;
    private final boolean hasGlint;
    private final class_2960 modelPath;

    public BookType(String name, int rgb, float angle, boolean hasGlint) {
        HSVColor col = new RGBColor(rgb).asHSV();
        float hueShift = angle < 0.0f ? BookType.getLegacyAllowedHueShift(col.asHSL()) : Math.max(1.0f, angle);
        this.name = name;
        this.hue = col.hue();
        this.hueShift = hueShift;
        this.hasGlint = hasGlint;
        this.modelPath = Supplementaries.res("block/books/book_" + name);
    }

    private static float getAllowedHueShift(HSVColor color) {
        float v = color.value();
        float minAngle = 0.19444445f;
        float addAngle = 0.18055555f;
        return minAngle + addAngle * (1.0f - v);
    }

    private static float getLegacyAllowedHueShift(HSLColor color) {
        float l = color.lightness();
        float s = ColorHelper.normalizeHSLSaturation(color.saturation(), l);
        float minAngle = 0.25f;
        float addAngle = 0.18055555f;
        float distLightSq = 2.0f;
        float distDarkSq = s * s + l * l;
        float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
        return minAngle + (1.0f - distSq) * addAngle;
    }

    public BookType(class_1767 color, float angle, boolean enchanted) {
        this(color.method_7792(), ColorUtils.pack((float[])color.method_7787()), angle, enchanted);
    }

    public BookType(class_1767 color) {
        this(color, -1.0f, false);
    }

    public BookType(String name, int rgb, boolean enchanted) {
        this(name, rgb, -1.0f, enchanted);
    }

    public boolean looksGoodNextTo(BookType other) {
        float diff = Math.abs(class_3532.method_15381((float)(this.hue * 360.0f), (float)(other.hue * 360.0f)) / 360.0f);
        return diff < (other.hueShift + this.hueShift) / 2.0f;
    }

    public String name() {
        return this.name;
    }

    public float hue() {
        return this.hue;
    }

    public float hueShift() {
        return this.hueShift;
    }

    public boolean hasGlint() {
        return this.hasGlint;
    }

    public class_2960 modelPath() {
        return this.modelPath;
    }
}

