/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import net.minecraft.class_2350;

public class DirectionBits {
    public static final byte ALL_DIRECTIONS = 63;
    private byte bits;

    public DirectionBits() {
        this.bits = 0;
    }

    public DirectionBits(byte bits) {
        this.bits = bits;
    }

    public void add(int index) {
        this.bits = (byte)(this.bits | 1 << index);
    }

    public void add(class_2350 direction) {
        this.bits = (byte)(this.bits | 1 << direction.ordinal());
    }

    public void remove(int index) {
        this.bits = (byte)(this.bits & ~(1 << index));
    }

    public void remove(class_2350 direction) {
        this.bits = (byte)(this.bits & ~(1 << direction.ordinal()));
    }

    public void clear() {
        this.bits = 0;
    }

    public void fill() {
        this.bits = (byte)63;
    }

    public boolean contains(int index) {
        return (this.bits & 1 << index) != 0;
    }

    public boolean contains(class_2350 direction) {
        return (this.bits & 1 << direction.ordinal()) != 0;
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean containsAny() {
        return this.bits != 0;
    }

    public boolean isFull() {
        return this.bits == 63;
    }

    public boolean notFull() {
        return this.bits != 63;
    }

    public static DirectionBits of(byte bits) {
        return new DirectionBits(bits);
    }

    public static DirectionBits of(short bits) {
        return new DirectionBits((byte)bits);
    }

    public static DirectionBits of(int bits) {
        return new DirectionBits((byte)bits);
    }

    public static DirectionBits fromStringByte(String str) {
        DirectionBits bits = new DirectionBits();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '1') {
                bits.add(i);
                continue;
            }
            if (str.charAt(i) == '0') continue;
            throw new IllegalArgumentException("Invalid character: " + str.charAt(i));
        }
        return bits;
    }

    public byte getBits() {
        return this.bits;
    }
}

