/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import carpet.utils.Translations;
import carpetfixes.CFSettings;
import carpetfixes.helpers.RuleScheduler;
import carpetfixes.settings.CustomSettingsManager;
import carpetfixes.testing.tests.TestManager;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2784;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetFixesServer
implements CarpetExtension,
ModInitializer {
    private static final SettingsManager carpetFixesSettingsManager;
    public static final RuleScheduler ruleScheduler;
    public static boolean areWorldsLoaded;
    public static final Logger LOGGER;
    private static final String MOD_ID = "carpet-fixes";
    private static final String MOD_NAME;
    private static final Version MOD_VERSION;

    public String version() {
        return MOD_VERSION.getFriendlyString();
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)new CarpetFixesServer());
        if (class_155.field_1125) {
            TestManager.initializeTests();
        }
    }

    public void onGameStarted() {
        carpetFixesSettingsManager.parseSettingsClass(CFSettings.class);
    }

    public void onServerLoaded(MinecraftServer server) {
        areWorldsLoaded = false;
    }

    public void onServerLoadedWorlds(MinecraftServer minecraftServer) {
        areWorldsLoaded = true;
        ruleScheduler.onWorldLoaded(minecraftServer);
    }

    public void onTick(MinecraftServer server) {
        if (CFSettings.scheduleWorldBorderReset) {
            CFSettings.scheduleWorldBorderReset = false;
            class_2784 worldBorder = server.method_30002().method_8621();
            worldBorder.method_11969(worldBorder.method_11965());
        }
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        carpetFixesSettingsManager.registerCommand(dispatcher, commandBuildContext);
    }

    public static SettingsManager getCarpetFixesSettingsManager() {
        return carpetFixesSettingsManager;
    }

    public SettingsManager extensionSettingsManager() {
        return carpetFixesSettingsManager;
    }

    public Map<String, String> canHasTranslations(String lang) {
        return Translations.getTranslationFromResourcePath((String)"assets/carpet-fixes/lang/%s.json".formatted(lang));
    }

    static {
        LOGGER = LoggerFactory.getLogger(CarpetFixesServer.class);
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(RuntimeException::new)).getMetadata();
        MOD_NAME = metadata.getName();
        MOD_VERSION = metadata.getVersion();
        areWorldsLoaded = false;
        carpetFixesSettingsManager = new CustomSettingsManager(MOD_VERSION.getFriendlyString(), MOD_ID, MOD_NAME);
        ruleScheduler = new RuleScheduler();
    }
}

