/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.mixins.entityFixes;

import carpetfixes.CFSettings;
import carpetfixes.helpers.CenterUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_5568;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class Entity_centerCollisionMixin
implements class_5568 {
    @Shadow
    public class_1937 field_6002;
    private final class_1297 self = (class_1297)this;

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public abstract void method_38785();

    @Redirect(method={"move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onSteppedOn(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/Entity;)V"))
    public void onSteppingCollisionCheck(class_2248 block, class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            CenterUtils.iterateTouchingBlocks(entity, blockPos -> {
                class_2680 blockState = world.method_8320((class_2338)blockPos);
                blockState.method_26204().method_9591(world, (class_2338)blockPos, blockState, entity);
            });
        } else {
            block.method_9591(world, pos, state, entity);
        }
    }

    @Redirect(method={"move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityLand(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;)V"))
    public void onEntityLandCollisionCheck(class_2248 block, class_1922 world, class_1297 entity) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            CenterUtils.iterateTouchingBlocks(entity, blockPos -> {
                class_2680 blockState = world.method_8320((class_2338)blockPos);
                blockState.method_26204().method_9502(world, entity);
            });
        } else {
            block.method_9502(world, entity);
        }
    }

    @Redirect(method={"fall(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V"))
    public void onFallCollisionCheck(class_2248 block, class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            CenterUtils.checkFallCollision(entity, fallDistance);
        } else {
            block.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    @Inject(method={"fall(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onFallStopVibration(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition, CallbackInfo ci) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            this.method_38785();
            ci.cancel();
        }
    }

    @Inject(method={"getJumpVelocityMultiplier()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void onJumpVelocityCollisionCheck(CallbackInfoReturnable<Float> cir) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            cir.setReturnValue((Object)Float.valueOf(CenterUtils.checkJumpVelocityOnCollision(this.self, this.field_6002)));
        }
    }

    @Inject(method={"getVelocityMultiplier()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void onVelocityCollisionCheck(CallbackInfoReturnable<Float> cir) {
        if (CFSettings.entityBlockCollisionUsingCenterFix) {
            cir.setReturnValue((Object)Float.valueOf(CenterUtils.checkVelocityOnCollision(this.self, this.field_6002)));
        }
    }
}

