/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Rule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import carpet.api.settings.Validator;
import carpet.utils.Translations;
import carpetfixes.CFSettings;
import carpetfixes.settings.VersionConditions;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class CustomSettingsManager
extends SettingsManager {
    private final String fancyName;

    public CustomSettingsManager(String version, String identifier, String modName) {
        super(version, identifier, modName);
        this.fancyName = modName;
    }

    /*
     * WARNING - void declaration
     */
    public int dumpAllRulesToStream(PrintStream ps, String category) {
        ps.println("# " + this.fancyName + " Settings");
        int totalRules = 0;
        int totalFixes = 0;
        int totalOptimizations = 0;
        int totalDupes = 0;
        int totalReIntroduced = 0;
        int totalParity = 0;
        int totalCrash = 0;
        int totalAdvanced = 0;
        int toBeRemoved = 0;
        for (Field f : CFSettings.class.getDeclaredFields()) {
            Rule rule = f.getAnnotation(Rule.class);
            if (rule == null) continue;
            ++totalRules;
            String defaultAsString = "";
            try {
                defaultAsString = CustomSettingsManager.convertToString(f.get(null));
            }
            catch (IllegalAccessException e2) {
                throw new IllegalStateException(e2);
            }
            boolean isStrict = rule.strict();
            List<String> categories = List.of(rule.categories());
            if (category != null && !categories.contains(category)) continue;
            if (category == null) {
                if (categories.contains("bugfix")) {
                    ++totalFixes;
                }
                if (categories.contains("optimization")) {
                    ++totalOptimizations;
                }
                if (categories.contains("dupe")) {
                    ++totalDupes;
                }
                if (categories.contains("reintroduce")) {
                    ++totalReIntroduced;
                }
                if (categories.contains("parity")) {
                    ++totalParity;
                }
                if (categories.contains("crashfix")) {
                    ++totalCrash;
                }
                if (categories.contains("advanced")) {
                    ++totalAdvanced;
                }
            }
            ps.println("## " + f.getName());
            CarpetRule parsedRule = this.getCarpetRule(f.getName());
            ps.println(RuleHelper.translatedDescription((CarpetRule)parsedRule) + "  ");
            String extra = Translations.trOrNull((String)String.format("%s.rule.%s.extra", parsedRule.settingsManager().identifier(), parsedRule.name()));
            if (Objects.nonNull(extra)) {
                for (String string : extra.split("\n")) {
                    void var25_32;
                    if (string.startsWith("[MC-")) {
                        String string2 = "Fixes: " + string;
                    }
                    ps.println(var25_32.replace("Warning!", "**Warning!**") + "  ");
                }
            }
            Class<?> type = f.getType();
            ps.println("* Type: `" + type.getSimpleName() + "`  ");
            ps.println("* Default value: `" + defaultAsString + "`  ");
            List<String> options = rule.options().length > 0 ? List.of(rule.options()) : (type == Boolean.TYPE ? List.of("true", "false") : (type == String.class && categories.contains("command") ? List.of("true", "false", "ops") : (type.isEnum() ? Arrays.stream(type.getEnumConstants()).map(e -> ((Enum)e).name().toLowerCase(Locale.ROOT)).toList() : List.of())));
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (Class v : rule.validators()) {
                validators.add((Validator)this.callConstructor(v));
            }
            String string = options.stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "));
            if (!string.isEmpty()) {
                ps.println((isStrict ? "* Required" : "* Suggested") + " options: " + string + "  ");
            }
            ps.println("* Categories: " + categories.stream().map(s -> "`" + s.toUpperCase(Locale.ROOT) + "`").collect(Collectors.joining(", ")) + "  ");
            ArrayList<String> conditions = new ArrayList<String>();
            for (Class condition : rule.conditions()) {
                try {
                    Constructor constr = condition.getDeclaredConstructor(new Class[0]);
                    constr.setAccessible(true);
                    Object newInstance = constr.newInstance(new Object[0]);
                    if (((Rule.Condition)newInstance).shouldRegister() || !(newInstance instanceof VersionConditions.CustomCondition)) continue;
                    VersionConditions.CustomCondition custom = (VersionConditions.CustomCondition)newInstance;
                    conditions.add(custom.getPredicate());
                }
                catch (ReflectiveOperationException e3) {
                    throw new RuntimeException(e3);
                }
            }
            if (conditions.size() > 0) {
                ++toBeRemoved;
                StringBuilder builder = new StringBuilder();
                int c = 0;
                builder.append("* Limited to: ");
                for (String cond : conditions) {
                    if (c++ != 0) {
                        builder.append(",");
                    }
                    builder.append("`").append(cond).append("`");
                }
                ps.println(builder);
            }
            boolean preamble = false;
            for (Validator validator : validators) {
                if (validator.description() == null) continue;
                if (!preamble) {
                    ps.println("* Additional notes:  ");
                    preamble = true;
                }
                ps.println("  * " + validator.description() + "  ");
            }
        }
        ps.println("# Stats");
        ps.println("Rules: `" + totalRules + "`  ");
        ps.println("Fixes: `" + totalFixes + "`  ");
        ps.println("Crash Fixes: `" + totalCrash + "`  ");
        ps.println("Dupe Fixes: `" + totalDupes + "`  ");
        ps.println("ReIntroduced: `" + totalReIntroduced + "`  ");
        ps.println("Optimizations: `" + totalOptimizations + "`  ");
        ps.println("Advanced Rules: `" + totalAdvanced + "`  ");
        ps.println("Parity Fixes: `" + totalParity + "`  ");
        ps.println("Rules to be removed next big release: `" + toBeRemoved + "`");
        return 1;
    }

    private <T> T callConstructor(Class<T> cls) {
        try {
            Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertToString(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase(Locale.ROOT);
        }
        return value.toString();
    }
}

