/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.blanketmc.blanket.ClientFixes;
import io.github.blanketmc.blanket.Config;
import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.ConfigHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.logging.log4j.Level;

public class ConfigJsonSerializer
implements JsonSerializer<Config>,
JsonDeserializer<Config> {
    public static final Gson serializer;

    public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject node = json.getAsJsonObject();
        ConfigHelper.iterateOnConfig((field, configEntry) -> {
            String entryName;
            String string = entryName = configEntry.name().equals("") ? field.getName() : configEntry.name();
            if (node.has(entryName)) {
                JsonObject configNode = node.get(entryName).getAsJsonObject();
                if (!configNode.has("value")) {
                    return;
                }
                ConfigJsonSerializer.fromJson(field, configNode.get("value"));
                if (configEntry.extraProperties().length != 0 && configNode.has("extra")) {
                    JsonObject extraNode = configNode.get("extra").getAsJsonObject();
                    for (String extraProperty : configEntry.extraProperties()) {
                        if (!extraNode.has(extraProperty)) continue;
                        try {
                            ConfigJsonSerializer.fromJson(Config.class.getField(extraProperty), extraNode.get(extraProperty));
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        return new Config();
    }

    public JsonElement serialize(Config src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject node = new JsonObject();
        node.addProperty("aboutConfig", "Blanket config: The mod only cares about the *value* property, you can edit, delete the others.");
        node.addProperty("aboutConfig2", "But if you save the config from the mod, it will override this file.");
        node.addProperty("aboutConfig3", "Good luck!");
        ConfigHelper.iterateOnConfig((field, configEntry) -> node.add(configEntry.name().equals("") ? field.getName() : configEntry.name(), this.writeField(src, field, configEntry)));
        return node;
    }

    public JsonElement writeField(Config ignored, Field field, ConfigEntry configEntry) throws IllegalAccessException {
        JsonObject node = new JsonObject();
        if (!configEntry.displayName().equals("")) {
            node.addProperty("name", configEntry.displayName());
        }
        if (!configEntry.description().equals("")) {
            node.addProperty("description", configEntry.description());
        }
        JsonArray issues = new JsonArray();
        for (String issue : configEntry.issues()) {
            issues.add(issue);
        }
        node.add("issues", (JsonElement)issues);
        JsonArray categories = new JsonArray();
        for (ConfigEntry.Category category : configEntry.categories()) {
            categories.add(category.toString());
        }
        node.add("categories", (JsonElement)categories);
        node.add("value", ConfigJsonSerializer.toJson(field));
        if (configEntry.extraProperties().length != 0) {
            JsonObject extraProps = new JsonObject();
            for (String extraProperty : configEntry.extraProperties()) {
                try {
                    extraProps.add(extraProperty, ConfigJsonSerializer.toJson(Config.class.getField(extraProperty)));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            node.add("extra", (JsonElement)extraProps);
        }
        return node;
    }

    protected static JsonElement toJson(Field field) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (type.equals(Boolean.TYPE)) {
            return new JsonPrimitive(Boolean.valueOf((Boolean)field.get(null)));
        }
        if (type.equals(Float.TYPE)) {
            return new JsonPrimitive((Number)Float.valueOf(((Float)field.get(null)).floatValue()));
        }
        if (type.equals(Double.TYPE)) {
            return new JsonPrimitive((Number)((Double)field.get(null)));
        }
        if (type.equals(Integer.TYPE)) {
            return new JsonPrimitive((Number)((Integer)field.get(null)));
        }
        if (type.equals(Long.TYPE)) {
            return new JsonPrimitive((Number)((Long)field.get(null)));
        }
        if (type.equals(String.class)) {
            return new JsonPrimitive((String)field.get(null));
        }
        if (type.isEnum()) {
            try {
                Method toString = type.getMethod("toString", new Class[0]);
                return new JsonPrimitive((String)toString.invoke(field.get(null), new Object[0]));
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("unknown type: " + type + " for field: " + field.getName());
    }

    protected static void fromJson(Field field, JsonElement configNode) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (type.equals(Boolean.TYPE)) {
            if (!configNode.getAsJsonPrimitive().isBoolean()) {
                return;
            }
            field.set(null, configNode.getAsBoolean());
        } else if (type.equals(Float.TYPE)) {
            if (!configNode.getAsJsonPrimitive().isNumber()) {
                return;
            }
            field.set(null, Float.valueOf(configNode.getAsFloat()));
        } else if (type.equals(Double.TYPE)) {
            if (!configNode.getAsJsonPrimitive().isNumber()) {
                return;
            }
            field.set(null, configNode.getAsDouble());
        } else if (type.equals(Integer.TYPE)) {
            if (!configNode.getAsJsonPrimitive().isNumber()) {
                return;
            }
            field.set(null, configNode.getAsInt());
        } else if (type.equals(Long.TYPE)) {
            if (!configNode.getAsJsonPrimitive().isNumber()) {
                return;
            }
            field.set(null, configNode.getAsLong());
        } else if (type.equals(String.class)) {
            if (!configNode.getAsJsonPrimitive().isString()) {
                return;
            }
            field.set(null, configNode.getAsString());
        } else if (type.isEnum()) {
            if (!configNode.getAsJsonPrimitive().isString()) {
                return;
            }
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                field.set(null, valueOf.invoke(null, configNode.getAsString()));
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            ClientFixes.log(Level.ERROR, "Config: " + field.getName() + " can not be imported: Unknown type", true);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(Config.class, (Object)new ConfigJsonSerializer());
        serializer = builder.create();
    }
}

