/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.services;

import com.natamus.collective_common_forge.services.helpers.TeleportHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class ForgeTeleportHelper
implements TeleportHelper {
    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, PortalInfo portalInfo) {
        return entity.changeDimension(serverLevel, (ITeleporter)new SimpleTeleporter(portalInfo));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, Vec3 vec3) {
        return this.teleportEntity(entity, serverLevel, new PortalInfo(vec3, entity.m_20184_(), entity.m_146908_(), entity.m_146909_()));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, BlockPos blockPos) {
        return this.teleportEntity(entity, serverLevel, new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ResourceKey<Level> targetDimension, Vec3 vec3) {
        if (entity.m_9236_().f_46443_) {
            return entity;
        }
        return this.teleportEntity(entity, entity.m_20194_().m_129880_(targetDimension), new PortalInfo(vec3, entity.m_20184_(), entity.m_146908_(), entity.m_146909_()));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ResourceKey<Level> targetDimension, BlockPos blockPos) {
        return this.teleportEntity(entity, targetDimension, new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5));
    }

    public record SimpleTeleporter(PortalInfo portalInfo) implements ITeleporter
    {
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destinationServerLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return this.portalInfo;
        }
    }
}

